package music;

public class RockSong extends Song {
	
	protected int noOfGuitars;

	public RockSong(String title, Author author, int year, String description,
			int noOfGuitar) {
		super(title, author, year, description);
		this.noOfGuitars = noOfGuitar;
	}
	
	public RockSong() {
		super();
		// TODO Auto-generated constructor stub
	}
	
	public void playRiff(String riff) {
		System.out.println(riff);
	}
	
	public void display() {
		super.display();
		System.out.println("Number of guitars: " + noOfGuitars);
	}
	
	public String toString() {
		return this.getTitle() + ", " + this.getAuthor().getName();
	}
	
	public boolean equals(Object arg0) {
		if (!(arg0 instanceof RockSong)) {
			return false;
		}
		RockSong rockSong = (RockSong) arg0;
		if (rockSong.getTitle().equals(this.getTitle())) {
			return true;
		}
		return false;
	}

	public int getNoOfGuitar() {
		return noOfGuitars;
	}

	public void setNoOfGuitar(int noOfGuitar) {
		this.noOfGuitars = noOfGuitar;
	}

}
